<?php 
   /*
    *
    * copyright (c) 2013-2021 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/index.php?alias=linee-guida-per-luso-del-logo-geecom
    */

    include "include/includeBase.php";
    include "../template/stile.php";
    
    include "include/controlloLogin.php";
    
    if(isset($_GET["id"])) {
        $fileScaricabile = $geecomDb->leggiSingolaRiga("geecB_risorse",filter_input(INPUT_GET,"id",FILTER_SANITIZE_NUMBER_INT));
    }
    
    if(isset($_GET["status"])) {
        $status = filter_input(INPUT_GET,"status",FILTER_SANITIZE_NUMBER_INT);
    }
    else {
        $status = 0;
    }
    
    $tipiRisorsa = ["Globale","Risorsa di gruppo","Utente singolo"];
?>
<!doctype html>
<html lang="en">
    <head>
        <!-- Required meta tags -->
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

        <?php
            include "include/cssBaseAreaAmministrativa.php";
        ?>
        <title>Geecom CMS - Crea file scaricabile</title>
    </head>
    <body>
    
        <header>
            <?php 
                include "include/barraSuperiore.php";

                include "include/header.php";

                include "include/barraMenu.php";
            ?>
        </header>

    <main role="main" class="bg-light" id="main">
        <div class="container-fluid">
                <div class="row py-4">
                    <div class="col-12">                        
                        <?php 
                            if($status==220) {
                                echo"<div class=\"alert alert-success alert-dismissible fade show\" role=\"alert\">
                                        Risorsa salvata
                                        <button type=\"button\" class=\"close\" data-dismiss=\"alert\" aria-label=\"Close\">
                                            <span aria-hidden=\"true\">&times;</span>
                                        </button>
                                    </div>";
                            }
                            else if($status==230) {
                                echo"<div class=\"alert alert-success alert-dismissible fade show\" role=\"alert\">
                                        Risorsa duplicata, modificala per renderla diversa
                                        <button type=\"button\" class=\"close\" data-dismiss=\"alert\" aria-label=\"Close\">
                                            <span aria-hidden=\"true\">&times;</span>
                                        </button>
                                    </div>";
                            }
                        ?>
                    </div>
                    <div class="col-lg-8">
                        <div class="form-row justify-content-between mb-3">
                            <div class="col-auto d-flex">
                                <nav aria-label="breadcrumb" class="align-self-center">
                                    <ol class="breadcrumb p-0 mb-1 mb-md-0 bg-transparent">
                                        <li class="breadcrumb-item"><a href="home.php">Home</a></li>
                                        <li class="breadcrumb-item"><a href="gestioneRisorse.php">Risorse</a></li>
                                        <li class="breadcrumb-item active" aria-current="page"><?php echo((isset($fileScaricabile)? $fileScaricabile["nome"] : "Nuova risorsa"))?></li>
                                    </ol>
                                </nav>
                            </div>
                            <div class="col-auto text-right">
                                <a class="btn btn-primary mr-1" href="../controller/controllerRisorse.php?operazione=creaFileScaricabile&id=0">Crea nuova<i class="fas fa-plus ml-2"></i></a>
                                <a class="btn btn-outline-primary" href="gestioneRisorse.php"><i class="fas fa-arrow-left mr-2"></i>Torna all'elenco</a>
                            </div>
                        </div>
                        <div class="card mb-4 box-shadow-lite">
                            <form name="formFileScaricabile" action="#" method="post">
                                <div class="card-header py-3">
                                    <div class="row">
                                        <div class="col-12 mb-3 d-md-flex align-items-center">
                                            <label class="mr-3 mb-md-0">Risorsa</label>
                                            <input  type="text" class="form-control" id="nomeRisorsa" name="nome" value="<?php echo((isset($fileScaricabile)? $fileScaricabile["nome"] : ""))?>" placeholder="Nome">
                                        </div>
                                    </div>
                                </div>
                                <div class="card-body">
                                    <input type="text" class="d-none" id="idRisorsa" value="<?php echo((isset($fileScaricabile) ? $fileScaricabile["id"] : "0")); ?>">

                                    <div class="form-group">
                                        <label for="sottotitolo-articolo">Descrizione</label>
                                        <textarea class="form-control" id="descrizioneRisorsa" name="descrizione" rows="2"><?php echo((isset($fileScaricabile)? $fileScaricabile["descrizione"] : ""))?></textarea>
                                        <small class="text-muted"> Se presente comparirà sotto il nome</small>
                                    </div>
                                
                                    <div class="row">
                                        <div class="form-group col-lg-4">
                                            <label for="categoria">Categoria</label>
                                            <select id="categoria" name="categoria" class="form-control">
                                                <option value="0">Seleziona</option>
                                                <?php 
                                                    $queryNomiTag = "SELECT * FROM geec_categorie WHERE tipo LIKE 'risorsa' AND categoriaMadre = 0";
                                                    $risNomi = $geecomDb->eseguiQueryLettura($queryNomiTag);
                                                    while($categoria = $risNomi->fetch_assoc()) {
                                                        if(isset($fileScaricabile) && $fileScaricabile["categoria"] == $categoria["id"]) {
                                                            $selezionato  = "selected";
                                                        }
                                                        else {
                                                            $selezionato  = "";
                                                        }
                                                        echo"<option value=\"{$categoria["id"]}\" $selezionato >{$categoria["nome"]}</option>";

                                                        // per ogni categoria madre vedo le categorie figlie
                                                        $queryNomiTag = "SELECT * FROM geec_categorie WHERE tipo LIKE 'risorsa' AND categoriaMadre = {$categoria["id"]}";
                                                        $risCategoriaFiglia = $geecomDb->eseguiQueryLettura($queryNomiTag);
                                                        while($categoriaFiglia = $risCategoriaFiglia->fetch_assoc()) {
                                                            if(isset($fileScaricabile) && $fileScaricabile["categoria"] == $categoriaFiglia["id"]) {
                                                                $selezionato  = "selected";
                                                            }
                                                            else {
                                                                $selezionato  = "";
                                                            }
                                                            echo"<option value=\"{$categoriaFiglia["id"]}\" $selezionato > - {$categoriaFiglia["nome"]}</option>";
                                                        }
                                                    }
                                                ?>
                                            </select>
                                        </div>

                                    </div>
                                </form>
                                    
                                <?php 
                                    if($fileScaricabile["percorso"]!="") {
                                        echo"<h6 id=\"labelFileAttuale\">Attualmente hai caricato il file <b>".str_replace("file/risorse/","",$fileScaricabile["percorso"])."</b></h6>";
                                    }
                                    else {
                                        echo"<h6 id=\"labelFileAttuale\">Non hai caricato nessun file</h6>";
                                    }
                                ?>
                                    
                                <form action="../controller/controllerRisorse.php" id="formCaricamentoRisorsa" class="dropzone" method="post" enctype="multipart/form-data">
                                    <div class="dz-message">
                                        <i class="fas fa-file-upload fa-2x mb-2"></i>
                                        <h5>Trascina o carica qui il file</h5>
                                    </div>
                                    <div class="fallback">
                                        <input name="file" type="file" />
                                    </div>
                                </form>
                                <button type="button" class="btn btn-primary float-right my-3" onclick="salvaRisorsa()"><i class="fas fa-check"></i> Salva</button>
                            </div>
                        </div>
                    </div><!--/Colonna principale -->
                    <!-- Colonna principale -->
                    <!--Colonna secondaria -->
                    <div class="col-lg-4 align-self-start sticky-top">
                        <div class="btn-group d-flex mb-3" role="group" aria-label="Basic example">
                            <button type="button" class="btn btn-primary w-100" onclick="salvaRisorsa()"><i class="fas fa-check mr-2"></i>Salva</button>
                            <button type="button" class="btn btn-warning w-100" onclick="location.href='../controller/controllerRisorse.php?id=<?php echo $fileScaricabile["id"] ?>&operazione=duplicaRisorsa';"><i class="far fa-clone mr-2"></i>Duplica</button>
                        </div>
            
                        <div class="card mb-3 rounded-0 accordion box-shadow-lite">
                            <div class="card-header collapsed" data-toggle="collapse" href="#ImmagineInEvidenza">
                                <a class="card-title">
                                    Immagine associata
                                </a>
                            </div>
                            <div id="ImmagineInEvidenza" class="collapse show">
                                <div class="card-body">
                                    <div class="img-container">
                                        <div class="azioni">
                                            <div class="btn-group" role="group" aria-label="">
                                                <button onclick="eliminaImmagineInEvidenza()" type="button" class="btn btn-sm btn-light elimina" data-toggle="tooltip" data-placement="bottom" title="Rimuovi"><i class="far fa-trash-alt"></i></button>
                                            </div>
                                        </div>
                                        <img id="immagineInEvidenza" class="img-fluid mb-3" src="../<?php echo((isset($fileScaricabile) && $fileScaricabile["immagine"]!="") ? $fileScaricabile["immagine"] : "immagini/altro/segnaposto.png") ?>" alt="immagine attuale">
                                    </div>

                                    <form action="../controller/controllerRisorse.php" id="frmFileUpload-00" class="dropzone singolo-file" method="post" enctype="multipart/form-data">
                                        <div class="dz-message">
                                            <i class="fas fa-file-upload fa-2x mb-2"></i>
                                            <h5>Trascina o carica qui l'immagine</h5>
                                        </div>
                                        <div class="fallback">
                                            <input name="file" type="file" />
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div><!--/Colonna secondaria -->
                </form>
            </div>
        </div>
    </main>

    <?php 
        include "include/footer.php";
       
        include "include/modal/modalMenuComponenti.php";
        
        include "include/modal/cambiaPassword.php";
        
        include "include/modal/operazioneCompletata.php";
    ?>
	  
        
	<!-- MODALS  -->
	<div class="modal fade" id="modalComponenteAggiornato" tabindex="-1" role="dialog" aria-labelledby="modifica componente intestazione" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered" role="document">
                <div class="modal-content bg-transparent">
                    <div class="modal-body m-0 p-0">
                        <div class="alert alert-success p-3 mb-0">
                            Componente aggiornato con successo
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true">×</span>
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <?php
            
            include "include/jsBaseAreaAmministrativa.php";
        ?>
        <!-- Dropzone -->
        <script type="text/javascript" src="../plugins/dropzone/dropzone.js"></script>
        <script>
            
            function salvaRisorsa() {
                var id                  = document.getElementById("idRisorsa").value;
                var nomeRisorsa         = document.getElementById("nomeRisorsa").value;
                var descrizioneRisorsa  = document.getElementById("descrizioneRisorsa").value;
                var categoria           = document.getElementById("categoria").value;
                
                if(nomeRisorsa.length>0) {
                    
                    $.ajax({
                        type:"POST",
                        url:"../controller/controllerRisorse.php",
                        data:{
                            operazione:"modificaFileScaricabile",
                            id:<?php echo $fileScaricabile["id"] ?>,
                            nome:nomeRisorsa,
                            descrizione:descrizioneRisorsa,
                            categoria:categoria
                        },
                        success:function(result) {
                            if(result=="ok") {
                                 location.href='creaFileScaricabile.php?id=<?php echo $fileScaricabile["id"] ?>&status==220';
                            }
                            else {
                                alert(result);
                            }
                        },
                        error: function(xhr,status,error) {
                            alert(status+" "+error);
                        }
                    });
                }
                else {
                    alert("Inserisci un nome");
                }
            }
            
            $("#formCaricamentoRisorsa").dropzone({
                acceptedFiles: ".jpeg,.jpg,.png,.gif,.svg,.zip,.rar,.doc,.docx,.xls,.xlsx,.ppt,.pptx,.odt,.odp,.pdf",
                maxFiles: 1,
                addRemoveLinks: true,
                dictRemoveFile: "Rimuovi",
                success: function(file,response) {
                    document.getElementById("labelFileAttuale").innerHTML="Attualmente hai caricato il file"+response;
                    this.removeAllFiles();
                },
                params:{
                    operazione:"modificaFile",
                    id:<?php echo $fileScaricabile["id"] ?>
                },
                maxfilesexceeded: function(file) {
                    this.removeAllFiles();
                    this.addFile(file);
                }
            });
            
            
            $(".singolo-file").dropzone({
                acceptedFiles: ".jpeg,.jpg,.png,.webp,.gif,.svg",
                maxFiles: 1,
                addRemoveLinks: true,
                dictRemoveFile: "Rimuovi",
                success: function(file,response) {
                    document.getElementById("immagineInEvidenza").src=response;
                    this.removeAllFiles();
                },
                params:{
                    operazione:"modificaImmagine",
                    id:<?php echo $fileScaricabile["id"] ?>
                },
                maxfilesexceeded: function(file) {
                    this.removeAllFiles();
                    this.addFile(file);
                }
            });  	
            
            function aggiungiAGruppo() {
                var idGruppo = document.getElementById("gruppoDaAggiungere").value;
               
                $.ajax({
                    type:"POST",
                    url:"../controller/controllerRisorse.php",
                    data:{
                        operazione:"aggiungiRisorsaAGruppo",
                        id:<?php echo $fileScaricabile["id"] ?>,
                        idGruppo:idGruppo
                    },
                    success:function(result) {
                        if(result=="ok") {
                             stampaGruppiAssociatiRisorsa();
                             document.getElementById("selectGruppo"+idGruppo).className = "d-none";
                             document.getElementById("gruppoDaAggiungere").value        = 0;
                        }
                        else {
                            alert(result);
                        }
                    },
                    error: function(xhr,status,error) {
                        alert(status+" "+error);
                    }
                });
            }
            
            function eliminaGruppoRisorsa(idGruppo) {
                $.ajax({
                    type:"POST",
                    url:"../controller/controllerRisorse.php",
                    data:{
                        operazione:"eliminaGruppoRisorsa",
                        id:<?php echo $fileScaricabile["id"] ?>,
                        idGruppo:idGruppo
                    },
                    success:function(result) {
                        if(result=="ok") {
                            document.getElementById("divGruppo"+idGruppo).className = "d-none";
                        }
                        else {
                            alert(result);
                        }
                    },
                    error: function(xhr,status,error) {
                        alert(status+" "+error);
                    }
                });
            }
            
            function stampaGruppiAssociatiRisorsa() {
                $.ajax({
                    type:"POST",
                    url:"../controller/controllerRisorse.php",
                    data:{
                        operazione:"stampaGruppiAssociatiRisorsa",
                        id:<?php echo $fileScaricabile["id"] ?>
                    },
                    success:function(result) {
                        document.getElementById("elencoGruppiAssociati").innerHTML = result;
                    },
                    error: function(xhr,status,error) {
                        alert(status+" "+error);
                    }
                });
            }
            
            function eliminaImmagineInEvidenza() {
                $.ajax({
                    type:"GET",
                    url:"../controller/controllerRisorse.php",
                    data:{
                        operazione:"eliminaImmagineInEvidenza",
                        id:<?php echo $fileScaricabile["id"] ?>
                    },
                    success:function(result) {
                        if(result=="ok") {
                            document.getElementById("immagineInEvidenza").src="../immagini/altro/segnaposto.png";
                        }
                    },
                    error: function() {
                        alert("Si sono verificato problemi durante la richiesta, riprova tra qualche istante");
                    }
                });
            }
            
            /*
             * Questa funzione mostra i div giusti in base al tipo di risorsa selezionato 
             */
            function mostraDivAccessibilita(scelta) {
                document.getElementById("divContenitoreDatiRisorsaDiGruppo").className = "d-none";
                document.getElementById("divContenitoreDatiRisorsaUtente").className = "d-none";
                
                if(scelta=="Globale") {
                    //nessuna azione necessaria, i div non devono essere visibili
                }
                else if(scelta=="Risorsa di gruppo") {
                    document.getElementById("divContenitoreDatiRisorsaDiGruppo").className  = "";
                }
                else if(scelta=="Utente singolo") {
                    document.getElementById("divContenitoreDatiRisorsaUtente").className  = "";
                }
            }
        </script>
        
    </body>
</html>
